/** @file   framegrabber.cpp
 * @brief   Implementation of FrameGrabber - class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/01/29 20:13:11 $
 * @author  Tomi Lamminsaari
 */

#include "framegrabber.h"
#include <allegro.h>
#include "Size2D.h"

namespace eng2d {


/** Constructor
 */
FrameGrabber::FrameGrabber( const std::string& filename, int blockW, int blockH ):
  m_filename( filename ),
  m_blockWidth( blockW ),
  m_blockHeight( blockH ),
  m_pBitmap( 0 )
{
  m_pBitmap = load_bitmap( filename.c_str(), 0 );
}



/** Constructor.
 */
FrameGrabber::FrameGrabber( const std::string& aFilename, const Size2D& aGridSize ):
  m_filename( aFilename ),
  m_blockWidth( aGridSize.iWidth ),
  m_blockHeight( aGridSize.iHeight ),
  m_pBitmap( 0 )
{
  m_pBitmap = load_bitmap( aFilename.c_str(), 0 );
}



/** Destructor
 */
FrameGrabber::~FrameGrabber()
{
  if ( m_pBitmap != 0 ) {
    destroy_bitmap( m_pBitmap );
    m_pBitmap = 0;
  }
}



/** Grabs the frame.
 */
BITMAP* FrameGrabber::grab( int col, int row ) const
{
  if ( m_pBitmap == 0 ) {
    return 0;
  }
  
  int x = col * m_blockWidth;
  int y = row * m_blockHeight;
  
  BITMAP* pTmpTarget = create_bitmap( m_blockWidth, m_blockHeight );
  if ( pTmpTarget == 0 ) {
    return 0;
  }
  
  blit ( m_pBitmap, pTmpTarget, x, y, 0,0, m_blockWidth, m_blockHeight );
  return pTmpTarget;
}



/** Grabs and converts the frame to rle-format
 */
RLE_SPRITE* FrameGrabber::grabRLE( int col, int row ) const
{
  if ( m_pBitmap == 0 ) {
    return 0;
  }
  
  int x = col * m_blockWidth;
  int y = row * m_blockHeight;
  
  BITMAP* pTmp = create_sub_bitmap( m_pBitmap, x,y, m_blockWidth, m_blockHeight );
  if ( pTmp == 0 ) {
    return 0;
  }
  
  RLE_SPRITE* pRle = get_rle_sprite( pTmp );
  destroy_bitmap( pTmp );
  return pRle;
}


} // end of namespace
